local my_db_path = db_path or "./scripts/database/"; dofile(my_db_path..'/scripts/GT.lua')
dofile(my_db_path..'/chassis/static.lua')

-- SA-3 SR S-125
GT = {}

set_recursive_metatable(GT, GT_generic_stationary)
GT.chassis = chassis; chassis = nil

GT.visual.shape = "Zil_P19_Radar"
GT.visual.shape_dstr = "Zil_P19_Radar_p_1"

GT.id = 34628898

GT.radar_rotation = -17.0

GT.sensor = {}
GT.sensor.max_range_finding_target = 80000
GT.sensor.min_range_finding_target = 1500
GT.sensor.max_alt_finding_target = 20000
GT.sensor.height = 5.841

GT.WS = {}
GT.WS.maxTargetDetectionRange = 80000
GT.WS.radar_type = 103


--Burning after hit
GT.visual.fire_size = 0.5; --relative burning size
GT.visual.fire_pos[1] = 0; -- center of burn at long axis shift(meters)
GT.visual.fire_pos[2] = 0; -- center of burn shift at vertical shift(meters)
GT.visual.fire_pos[3] = 0; -- center of burn at transverse axis shift(meters)
GT.visual.fire_time = 500; --burning time (seconds)

GT.CLSID = "{0A988814-8015-4d7a-906A-0BC419EF0DBC}"
GT.name = "SA-3 P-19 SR"
GT.displayname = _("SAM SA-3 P-19 SR")
GT.score = 20

GT.Sensors = { OPTIC = {"generic tank daysight", "human nightsight", "human daysight",}, RADAR = GT.Name, };

for i = 1,10 do -- 10 tracker's
    GT.WS[inc_ws()] = {}
	GT.WS[ws].newZ = true
    GT.WS[ws].base = 1
    GT.WS[ws].pos = {0,3,0}
	GT.WS[ws].drawArgument1 = 0
	GT.WS[ws].drawArgument2 = 1
    GT.WS[ws].maxBottom = 0
    GT.WS[ws].maxTop = math.rad(80)
    GT.WS[ws].omegaY = 1
    GT.WS[ws].omegaZ = 1
    GT.WS[ws].reference_angle_Z = 0

    GT.WS[ws].LN = {}
    GT.WS[ws].LN[1] = {}
    GT.WS[ws].LN[1].max_number_of_missiles_channels = 2
    GT.WS[ws].LN[1].type = 101
    GT.WS[ws].LN[1].distanceMin = 0
    GT.WS[ws].LN[1].distanceMax = GT.sensor.max_range_finding_target
    GT.WS[ws].LN[1].min_trg_alt = 25
    GT.WS[ws].LN[1].max_trg_alt = 20000
    GT.WS[ws].LN[1].reactionTime = 9
    GT.WS[ws].LN[1].type_ammunition={0,0,0,0}
end --for

--GT.WS[ws].LN[1].fireAnimationArgument = 23

register_car(
  {
        CLSID = GT.CLSID,
        Name = GT.name,
        DisplayName = GT.displayname,
        DetectionRange  = GT.sensor.max_range_finding_target,
        ThreatRange = 0,
        Rate = GT.score,
        mapclasskey = "P0091000083",
  }, 
  {
    register_car_cat("{463C474A-E87E-4da5-94C9-ACAE0E3D47A3}", "Radar"),
  }
);

